;coded by UEZ 2013 - based on Mars' code
#AutoIt3Wrapper_UseX64=n
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

Break(0)
#include <GDIPlus.au3>

AutoItSetOption("GUIOnEventMode", 1)
AutoItSetOption("MustDeclareVars", 1)

SplashTextOn("", "Please wait while the image is tiled....", 350, 42, -1, -1, 1)

_GDIPlus_Startup()

Global $ghGDIPDll = $__g_hGDIPDll
Global Const $hBitmap = _GDIPlus_BitmapCreateFromMemory(_AutoIt_Logo())
Global Const $iWidth = _GDIPlus_ImageGetWidth($hBitmap), $iHeight =  _GDIPlus_ImageGetHeight($hBitmap)
ConsoleWrite($iWidth & "x" & $iHeight & @LF)
Global $iTiles = 64, $iSumTiles = $iTiles^2, $iW = 468, $iH = 374, $iPosX = ($iW - $iWidth) / 2, $iPosY = ($iH - $iHeight) / 2, $iTiles_Width = $iWidth / $iTiles, $iTiles_Height = $iHeight / $iTiles, _
	   $iMulti = $iTiles_Width / 2, $2Multi = 2 * $iMulti
Global $hGUI, $hDC, $hDC_Backbuffer,$DC_Obj, $hBMP_tmp, $hCtxt, $hCtxt_tmp, $hBmps[$iTiles][$iTiles], $hBrush, $iFrameTimer = TimerInit(), _
	   $hHBitmap, $x, $y, $iTMP, $iSin = 0, $hFormat, $hFamily, $hFont, $tLayout, $sText, $aInfo, $fScroller_Height, $iY = $iH + 20

$hGUI = GUICreate("GDI+ Wobbling Logo " & $iSumTiles & " tiles / 0  fps", $iW, $iH)
$hBMP_tmp = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
$hHBITMAP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBMP_tmp)
_GDIPlus_BitmapDispose($hBMP_tmp)

$hDC  = _WinAPI_GetDC($hGUI)
$hDC_Backbuffer  = _WinAPI_CreateCompatibleDC($hDC)
$DC_Obj = _WinAPI_SelectObject($hDC_Backbuffer, $hHBITMAP)
$hCtxt = _GDIPlus_GraphicsCreateFromHDC($hDC_Backbuffer)
_GDIPlus_GraphicsSetCompositingQuality($hCtxt, 2)
;~ _GDIPlus_GraphicsSetInterpolationMode($hCtxt, 3)
Global $iT = TimerInit()
For $y = 0 To UBound($hBmps) - 1
	For $x = 0 To UBound($hBmps, 2) - 1
		$hBmps[$y][$x] = _GDIPlus_BitmapCreateFromScan0($iTiles_Width, $iTiles_Height)
		$hCtxt_tmp = _GDIPlus_ImageGetGraphicsContext($hBmps[$y][$x])
		_GDIPlus_GraphicsSetCompositingQuality($hCtxt_tmp, 2)
		$hBrush = _GDIPlus_TextureCreate2($hBitmap, $x * $iTiles_Width, $y * $iTiles_Height, $iTiles_Width, $iTiles_Height)
		_GDIPlus_GraphicsFillRect($hCtxt_tmp, 0, 0, $iTiles_Width, $iTiles_Height, $hBrush)
		_GDIPlus_GraphicsDispose($hCtxt_tmp)
		_GDIPlus_BrushDispose($hBrush)
	Next
Next
ConsoleWrite(TimerDiff($iT) & " ms for generating " & UBound($hBmps) * UBound($hBmps, 2) & " tiles" & @LF)

SplashOff()
GUISetOnEvent(-3, "_Exit", $hGUI)
GUISetState(@SW_SHOW, $hGUI)

Global Const $ghGDI32Dll = DllOpen("gdi32.dll"), $iUB1 = UBound($hBmps, 2) - 1, $iUB2 = UBound($hBmps) - 1, $fFactor = 1.4
$iTiles_Width *= $fFactor
$iTiles_Height *= $fFactor

GUIRegisterMsg(0x000F, "WM_PAINT")

Global $iTimerFPS = TimerInit(), $iFPS

While Sleep(10)
    $iSin += TimerDiff($iFrameTimer) / 35
	DllCall($ghGDIPDll, "int", "GdipGraphicsClear", "handle", $hCtxt, "dword", 0xFF808080)
;~ 	_GDIPlus_GraphicsClear($hCtxt, 0xFF808080)
    For $x = 0 To $iUB1
        $iTMP = 2 * $x * $iMulti
        For $y = 0 To $iUB2
			DllCall($ghGDIPDll, "int", "GdipDrawImageRect", "handle", $hCtxt, "handle", $hBmps[$y][$x], _
			"float", $iPosX + 10 * Cos($y * $iMulti / (22 + Sin($iSin / 6) * 10) + $iSin) + $iTMP, _
			"float", $iPosY + 12 * Sin($x * $iMulti / (28 - Cos($iSin / 8) * 12) + $iSin) + $y * $2Multi, _
			"float", $iTiles_Width, _
			"float", $iTiles_Height)
;~ 			_GDIPlus_GraphicsDrawImageRect($hCtxt, $hBmps[$y][$x], $iPosX + 10 * Cos($y * $iMulti / (22 + Sin($iSin / 6) * 10) + $iSin) + $iTMP, $iPosY + 12 * Sin($x * $iMulti / (28 - Cos($iSin / 8) * 12) + $iSin) + $y * $2Multi, $iTiles_Width, $iTiles_Height)
		Next
    Next
	$iFPS += 1
	$iFrameTimer = TimerInit()
    DllCall($ghGDI32Dll, "bool", "BitBlt", "ptr", $hDC, "int", 0, "int", 0, "int", $iW, "int", $iH, "ptr", $hDC_Backbuffer, "int", 0, "int", 0, "dword", 0xCC0020)
	If TimerDiff($iTimerFPS) > 999 Then
		WinSetTitle($hGUI, "", "GDI+ Wobbling Logo " & $iSumTiles & " tiles / " & $iFPS & " fps")
		$iFPS = 0
		$iTimerFPS = TimerInit()
	EndIf
WEnd

Func WM_PAINT()
	DllCall($ghGDI32Dll, "bool", "BitBlt", "ptr", $hDC, "int", 0, "int", 0, "int", $iW, "int", $iH, "ptr", $hDC_Backbuffer, "int", 0, "int", 0, "dword", 0xCC0020)
	Return "GUI_RUNDEFMSG"
EndFunc

Func _Exit()
	GUIRegisterMsg(0x000F, "")
	_GDIPlus_GraphicsDispose($hCtxt)
	_WinAPI_SelectObject($hDC_Backbuffer, $DC_Obj)
	_WinAPI_DeleteObject($hHBITMAP)
	_WinAPI_ReleaseDC($hGUI, $hDC)
    _GDIPlus_BitmapDispose($hBitmap)
	For $y = 0 To UBound($hBmps) - 1
		For $x = 0 To UBound($hBmps, 2) - 1
			_GDIPlus_BitmapDispose($hBmps[$y][$x])
		Next
	Next
    _GDIPlus_Shutdown()
	DllClose($ghGDI32Dll)
    Exit
EndFunc   ;==>_Exit

;Code below was generated by: 'File to Base64 String' Code Generator v1.12 Build 2013-05-17

Func _AutoIt_Logo($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $AutoIt_Logo
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= 'bNKIg1auXFlKsVXT8ePHz2I9S9T6+6ykUcLrCq5f27WDBw86f6vfGWFnoF9x4xYi7dy506OaUuoYjHF3WUAXhHhVT3ZwTjl16tTxBAAgrfj19fXrST31gjoNkIIdlD/p6bskiB0PsCm6da91T1g/3oqCB10zgQAlVyDIgr2J21bO9a7Mn7NrL4xPrr83e/bsNiaAP+2Mq/aWW+Mv50XptfeDgDyH45Lt3r27jYmQybBqBhw3AAAo4zVizxkAkKb70Kwfovzj2ApbAmXMlMmmVx8/tUqeeiCISl2Txlrs1Fd010Apr2ZhhK0hXbXOwIhz6LVAd0Cj9bQwzKfDpkovLoy4Fiinsz/Av7OT9wF6hw4dkt/2g03cMmb/TkZ2kveBQYyW0+oG+AAgXcQDXdyM8n8aqz8UC5LNPnfN30eyHAx6FMofXWm1j+7P+3oz82DtWAvBLEL1oUCLuQt6JmVzRgtVCOSsFbXC9HFrIWArHkbHu3Pnjnfx4kU/S3AAgRp/k8lx3WEBSIxgaDbs9gvst2hMA0C7UKZbwGaUw7wIchgTkS8BPh/dNxTSPpdksS21HXTSa6GAQamp7VbYFpxmK7u9wK1xiOfvR6nvD+rdMbazOR0+L8VKHtulZax1o49jzakqNWIMLkDLd4l7hDvUl92XH0q7AAh0vzfBoY0Edj5OscQIqdGnblpz+WaqzJFUgoGdObDfYGMrfZC1tHbMJWrpE44D0IwAoh3sNCTI6sd9NwBiuQ9xg640P5g6u/nYvKN/FwjY7njbc8WaljVfsmfPnpL2CuBHTy0AYPX7Qbn20apJ6+Vpya7Wh4eWzrf6gVFsQxzlpRnFLGaQL2xvHVu9c2wopgEURl1A9HoL83fkWBin+PYCAKzHDoFGQYKXfhigG39MuScHtyiXwxzavacSANiP//nly5d/idzwCAY+RhWZY/XNSbUnPOWU/3/kfQuQHdWZ3t/n9H3OSzOjkWYkQAZsA4Ylu45j52mHCk5cSUwMxW5CEbwhjrMOzoY4mKKAJE5sp1wh2SrHcWorldpkqxyMizgpr4OJsdEasIFFlgAb2SAQDwmh17w1o8fo3u7O9/99XnXqXvXVUElJ+IrDOX369HTPnf7+5+NE3MhxLLtXHfpwHNaWt+MwHt4W7wh7t1cdeokoQ2/nYtG0f7/+SMBqgrB+zl+VVDUw90chE7HOw+B4lnYOX1EJoLffdyiB2N6O7ftb5XWI7x8SED5I4EUYBsMzBOBXy8L/X8D1P8iuPRhcFMR+W2J5vdx9MBHt7YM/fDFcCm3cQNBYRxRjkq0zgGNuhQF8glbkpqosFRY4BFDXSSl5KXE70T0LvCcJEkrE7YRAGkLEnTRYk6XBZuLCcnEsRAKEIxTRB1cX1i8N9HPHValiMdDjNhDhQEUnQgYofe1rX6uyV8Scuy/Y8QmB7xr2LeAcAXscSxYDMQ0QGSYA4yAAR4UA/KrE76NM0nfRfg1AqaNybbzpQxXI///r/N6SbV1aAmiWWOChEJcQevZJFyBkBYDNa3JcI9AwHMWgCB1GRQFQkMJxTqlOKQ9enpyHaEXO4MmJTy0uLRcLi0tJ1u3mnY4QyjzBhwGvtZYepc0SFO5IEGnGOeiEhBshEiAYVmqIufvb2VprUAPhIHaaCs4/uCcA2YlixX/ggQcqCR/aumwT8OMTwtDP2oAZuwPL0o1J/VfGCAgL/1344m5GIsiV4ITC9SHyV1v4qwmDn3v7PvsY8MLR+VmZWCGdk5DOyfHhBY4zAL2rdU01Wo1UoE2kcoBbYQ7nqJt1KetmJRiMmMlcnUJgURJxIkF/2aPlwHrB/vNcfo6qMWfXWjGn72RYR4pWVk8UKyurxd69r3ZAIArO1MN5xeXKET/PvmcuLS4EAVwnIggR+KvnqmLozwYMvY7X6wqUhvLiTIBtlGClxyMuqhrHB8TXo3gq7dmzR4hNbLsZ4BNLGvpXggDccsstvNXTbRD5LwDnZECFfv2KVp0q'
	$AutoIt_Logo &= '+nY/cTEMAF64Om/EgSouAnpw+nx19XiRpjppNFpJNye9drqbnjp1nPIF5uSatOjtKaXQzZvtEaqxrg6waYj1aco6fIOULtckSgsxUBoNY/kA5BkTAXmWLuVCQDrUAaHsou922J6AQiY4Xls7zaoG5jN+bpYOgCG+XZNS3OfEyVPFs88+lz+zY0c+1G4rgD9BLHrCBAEhusSSAiQGURtADBgAZ1cWq1rcXQ9hP5tYgPj6MIJUgsYeffTRKmknJgA9iUEcHXjfffdJSDCkq3WrmzERS9+p+v4nPvGJ+5HAczU40paKaL6ztSK/3UKdlgg50Z6J0759+yTIY/fu3RlE/Y4CqsFRVQLIdgC2FYCOimNAWpMarTaNjm+kuujgLQC+gXELoBoCAWjjGPMNAD8FAahxIc4GaQa8TgX0Cf/jYyJRA0T6FyKQU8G2AjQBuJTsAgHIjDGRqxWfWKWTJxAnceokdZgooK1hvHbyBGwNK7wmASgSgFvV8RxLUCOeeWZH9tTTT3fbrZaGdJDyPgKoliQEAYU+hBhAZVlH0NA6re/94/jfjidBGmoUiNSGWnyDBE2dqcVETxKDkORE2Lk4tgOcDfgTbu9UAiDgxxf0PRhMPgBOVYPI7OrpA3Trzcgb1PdemSkHTi+gZ6KEajYs1rMlOT96dDYHp07AxdWp051mp3OSlpaPCfduANxTG6aoPTyMtoGGIE63hkaphflmq0mQDLCGWxPgr1HDAF+nmrk+mhJVQCeKCmMFwNMZI6DhcjkaT6DPCubuORMC6cV7kHUAeDQ2QIIQAOjomQCsCUE4eRyFTVeO0fHVJTqxuoK5VdgQloQgEPFjpBqEqHjllb3Zz194oUBJZAVxVqFQh+S+Q10Q+wGIgeV8VepAVetlLT+TcTAmFmeVCAVibg/FKBivj8upa61DTi8RgC+++CIhUOeMQUZ79+6159dlT4pV3/QdlrN/JXT+b6Hu2xWwgmtw0jiiL26DWnwFBL0+WusqguH0ehAkEe2xYw7t2rUrh27fVYBGqz2k0lpdzc7PG6v6EG2YGKJGexhgh0FtwyQNj4zB0j5CQ2itdluA0sBaEAzpa8LpawbwqYj+IuYztxdAkYwLIjkG4o0R0HBBbqzbY17GOeuKHcqz0g6QdzPqZPg9OmgZxqwWYCyuRu5BDFjKOgFisMreh2WoXMcWaXV5EcQAZdEwPz+/kGCdbrZKaWXnzl05SwfwNigEZWkuEw6CwLXshBDg9znbSrp9S2ejr4zNR+trDARoo793v+YBHjOCeA2kHrtGJCJs+S1bsqGWgbtvLLWAqcXPN5D6E6qaaKfeaQRAwP+lL33pWwh3fB8CexTAz8a+den7AvZq0S9eG4PfhWCCGDHwxWfMm2jCcJaDm6cqrddXwS1hTANHH6aZre+iEYBdAD+6AaAfpZEx9Mz52xDvmw1w/abR6+si+tdqmnSiSaVo6LVmwKNpw13C2k+5/FeSAX5szaDHOHzpiY+tatCUcbzlWCZEoUMZ71iUZSbWoCOEYA2E4BSrBSfXxKZx4vgqVIMlWl1aRj9Lq4sgDCtLIs6CkKhmo6FgPygef/yJLgxdCYiARkVgAQPsBazvxobDuK+qRVAh4le7CEPVEeOzfoe01m4uZgwhEYjdgVgfS678LvS7b1XIs9tGDm7i4+8oAgAL/5+99957/zN8slewfz/a5LGqxV9SBfgrRUSXmw7dXkQ25GEz189PQhVpNNvq5NppffzEnIB+fOMMDY1OguNvlDY+uZFGGfzC6Vvia2+1Sn97PW2QBvjTVJFWGk0RUI85C4LE/id9CH4qSsArM0x0QeI5SAzHJ68OyNJMqIAnZqw+6CIgEHXKczEcShNjYZ5RF4TgdLdbGgy5yi/sA6dOoj95QgjC0uIcLc7P0tL8EUgHC1AZjtGhI0fYbpBia2Pa8dOd+XPPPUfYOyGBVJBgExWJfoMhlyWCKp160P0Oz1hW23wqOS2AfSYGUMkkwgb7'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= 'd7eCfYUsNcj3QwBoRIU6hlDcbsswc7fSNFVk7tR889JLL4UlS5bArcv/EU5ZdqaX2Z8FTZPcpIcGgUNO9kv0TxlwhhmAxwyIUqwmdntEO7Pnx+91P48JOCZaFUAwRoocM4EkJGbNDdA5kjCqtLMp0DFEpsAg3nfyCmzuQNyFU4cxypViA1pJ/WaAd54JKK5F2i11xn4f4jtfeE8xAAQvpi5YsOBEDC2die45khblARHFnOqm5MRFhS6pPd27+6pjUIVpU3Dyo+oftXdAEFWFk0dEMnCVAWjkfODF6YttHvoOeVzaRBQJ49KMMRdK4IxY54Hlr5OZEAmTSSKrEWgBQKbS07ZQz8ETwoEjdFrj6yWAgAa3goaXXvAdWDD/INSwjoYtW7em/RLpnGGYmTS4oRRItdoCYVNswLb5XgObrGOjo8SE2CV20003wVLMIfizj30CZs6ebRJdB7pO99iJKmCT3Zlkz4KDZgrYtel/z/aPhXABcVyMKrQN2X6GoSE4pC2qa5BNgQouE4fbQqBtLFg6J89AMLAfRpBQ84THHltbQ0ldRZu9ESBYZmblhJ4xDw1pR5xhIkbQLkKPwLEYor32PcEA8Gb8e+Rcs7AKT4BqerHSSbn0b6b++0E/8cbnXwjf2NENXTPmouq/H/n7iVMjqb/fUH6r5ceTX4E1M9z9tFsbJAVAMEYKYpdKDXYNKsJtsQMuSCCyb4t5IEUzFATUmR/RduDtGkLokiAFCOV82tjj5/94Fbzy4rNw/+rV8Aba/Sz5AcjDURZIpffznRNAASxVGhwa4uSrQw45BD77Xz4DN153JZx7/kUqsQ0INMlvcl+XKvWNNxSChhKXvo+d7p/wek3wGXMxe9iCz1ia4AIWEEYcWbxFNH7Ik8KzPxBQsALtXZOhHTWBdmQAO7Zvwf6QOyuYPzGGXoE2ChBCoWdjufg8GmEAeU3Az2lRLWA+prSf8V5hADQQPomFFWfhJKULaab6N7sJrTL91PYn+3esu6e/s9I5BSjevw1Vf07wqVTEntMEH0Z9mYQL5PLJ01z3sFF0WdAAImQtQFJQE2EEkv7rvJBdx/80Y4/NADu+lyTk/GsEqYAbCbDlYQVbX90Et998I9x7952wE23+3r4+zl1XwA90kJUxAF2WU3NMoEFgSw8CvTQBvv3tbwOafnD1pRfBf/3qeWbDO29Si6TWyUxrZgbpF/gz38XnYwumOTjnAX9JbuLbF4yZ2A6BE+9AoKCgS+9nyNGCKX7kCJyTluZxyFWEOlHTHB1AYHtyP7y29c1gw4anA2J+iAWQxPYLfJSVByfyJ74uiUhzZiZw0EEHTUaX4yLtv7ovMwDKNDsS3X+LAWCqN6HHG/nXUmVSYJC6urz62taO3UN70OWHqD9Kf67lV0mDfZJI7XxB/MGvZZ+PwgHP3+4j7VCPJIsCqY7rWECI5EntdReDZvNAoFIsZDMja2J4qcMRV8m1Yvsi6YVZSAFL8yHSd9G2vg6+es5XaICRu49U72xlWkWhbT1PWXs/DN8pA2iondUQD0CNj8Gwe++9Fw6eNw+OP/EUmHvoQlP/a8TfGroCjXHlwT3JBbbPAgUV+d6z2s9UK+QKFhMJcsxIMabA3IMM7oSOJzzUyBwjF3Is3YsJUHaoaU6AdmQCZAoMICbQ3dNTxW48NTQBOG0YqSQuYFwRsAoGEoUYhj0TXYKnIBZwK/weX+EfIOX3VHQNzZcS3y0v0L9QXcqrZWHEJ37xi3h332BQ7Zgsdn8Xq/6BtlGGVKXTDhiOH7RIyoI6mFdJmSzMVCVV/a1ILxdrmDCSVZxRPIERaZFocQ64ch6gFcceOOYYBeCTOS999sofnA8j/TvhjDPOYJVwZHRUB3CrltGtctfz28qaURRq19nS9hsSU4CThzBa8K5bbsyi/RKlbza+MdPEJXaPnblTeclrGgSF7+J00tfqQT+xfKfoJWDi52NP2hH5XhciNQW0PRPQeiTFEyMeO6oJQBTh'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= 'dqnwnP0NMZEBhKb12TOWlD/9KarWg+IS5q3wNRnFCRIBh02jMKYNge/ZkYA1pABIA0AtajQpKQpSUhOyoAGQsKF52UU5Af+fvfeAtuOsDoX3zJxzm65qL7YkS7Iky7ItV7k3ueCODaYZMOAQCBBKTDAlj7KSwFpZeSwChBdSXn4gvIQ88ptmsMENy7VIsixLbpIsW8XqVrvlnDPzzdt7n73X/s7MmXOuMJJtorG2v5lv6p0zu7eDJwEYBepCIHdGs32tkFyNfdnjrQdAHKe4BGz5l9LLnISiL1Vy7M0S64v8CYB85MzztXSTug75ssIlogAiwT62L/iFRdhbELDFmi8TBZZEpI8Q4igegn17tvLH+M9///fEpRhJqtUKCNrqYvXlreWYb9ewItRaLdRG/30Jx6L1Rmki5BZoCezEZ7j77ruhhG69xdd+AEaOGU/vnPaJ1KQcWxFSl3xeQlcPhq+efA5sWLsa7rzzTpRu3grljg6S1MjyLBxd1RAEOdEjeDpvD6zx//zP46pBKMel+XBYPo3tAWgU3MUFVD/5sQ/CD35+K5x2xR8LUTaCYeqbIpS3z7I41YhrPn8V/Z3PcPhiOe5vfSCcEWI1RDojZT5hqMUJQhyoylO4mPTcNotW4zyQ+xNidRxMAqCi+nD88csoehQ/dF7/11GhmduQDE0pcTBCVVwEQQLTwwTMZ5ZI1JXiiyIQ6ASkch2l2tyeOwnAsSahxStAo4M4I1CRPfXif+p2iUCCfTT1KoDV9/8EPv7Bd2Gc9wLsYbCZ/f0qFvtL4IvLMoro67v37Fxv9P+kMBtoI65JWt+1cxeL6889vwYuePNNMH7qTG6imjgLotK0aSNLeRpgN4ygd/QEOPeKd8PPvv8/4Z577uF238hpEDqhVIra/LZKEfSCcn/P2BbamFMF9Lo6EycJxzR04/1vvvlmDl1eteRWmHvGNRYBCjT62ZLqCTLXoO1XY5+um8piHFdAzvUbyoAwDWYHAd8nQ0Q9SsAdrvtQktrmJk0cH7Zxhzcbi0qtkwpA2ZwdmBg062CrAERpRmEZsM5cD8DiZpNDpnZJ4oKac2GgHVjBjG5CcYW7ExjzpxWj1JANDPJDe3U+l9giB+W60LjE60YjhSVBYtJX3vsjGN+xH973vvehkWqnX9I7x8XAiKMhur2X1npwUbcem8N798OatWuY+8/AqLl5C8+iUF8loPY3CTgBK4rhb3sCV1iCUeMmwzmX3wCbtmxn1+DePXtB2sC3su+07UTcdCmYl6uIa3AX5zV8+9vfhjXLboetL6zE04qQ34y/Ddxb97lUBEjzFhH4EYf2jZn0YGqpuQVti1+upRiLJBQnXB8xlMpLr6KDtq1rViB2CRqBRvSRtOsgSgDMgToRSqIC+Ea+toYMFf/1+Hw76ar0ZueMP+P8dLxzTK5oUBrgOChHViQUOICE9F3hsgrQqDfjsREem3D/AObo0mYshQg8VZWlAc4A41JfKacG14NYdqxbCU/f/18UZEMfJEeu1fSdBGGGC1pDAZkSzmZzuJnbFoYjpxYgESehxVzg43bU+3vHToHzUO8nSz5AYASOFzHWqSQgxEGlAhOcGh+/jFLE5OlzYM4JZ6Iq8Bv62Jj7o9UJ4wqG+3YN/+9X0VdBbqRjbk6kNZ0D/12ZN4iJXR95BSgEFr7zd1+Hz331OzDyiLkkOapkYWXCnDZ8bQz9xaFeKdgX/c3g1yjmO1/0d5Yg5ttP9FyelCeVe2pfijimXIk4LXKXt+msVZgdSLhIhnncN0yYenIwbQAddF5GvG/nsijUZXwCsm8fZcrVBGEbEcbUQ/thAiUOWrUjMD3eRG0rIRYwsqsy7iB0YV2sVwLDEYE0hdu0zojPaALOkUFPioHUKrB22a/he9/7HhE1CpllzkRL6L8PRbrAxH/DMrEDaD2B3Lb+SalwYplT4pmqO8tR+zR46KGHYPe+frjqxo/ByHFTuIWaujWtd4lsy6RsybqNGfzn'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '0FG5P0nGDi3/G1D0p2o/uZTfN74EYFBBpE0R8ccjQk1EDj0SJQBSBTReWqGt68QQvjhuQKIPqacAdHaU0wceeiCEoMSIB+wfL1nCiO/7B5/Dh+q2Ew5v8fJ2jCKxxQ6YVYwRwLdNmQgfaeZfqCPu8uL709DLCpR9oewT4GMDkxLE8WZIJ/cW7V8Ij6pXBk7X1coO2ZRoRSq/bbpF5MvI19bQaZf4end95F2pL8XxPkJ6hIQRP2bx3Bm3t/Rh8+/bA2cahMizQayhw8b5AycVfMnlR1AR5B+op/jiOsX5v/26y9P3v++9KRqUI9T7SaVsVdouD+07/RJoui81j91Off5R0vipEID+P1QC4BCocGKItoDJZBBE6JKSx+04fpG7sJBoaA5CiMvFFy2G3u4ud/+D94cAkRSkDLlnQAD5hhmq39tE6B9n6oGI+CyJyjk88jWUEYZyTMhIkpCILDoF6/9ggT+sLqgxUMV5v5IP2IcVWYFPaYQi9/bUArFG+hGDHtcNbF23FYec5iXY6CSs2S+/bbq9St48K1KJEg+LEfA7/CTOMZev1WKokd7N3Fx1+cC4fLYgiOYA+4jvnD2PPoy6BgMemeOzzh9LMw/R+Rn5cR3SAXjv29+cfvrmTzkUxyO0xpN72bfy0zjEzr7Fur/v98f7VNetW/ccSgD/Rcl/CNsQ0j88AmBQRajhi+1FO8BRGCE4hqz2UvrIELm9/7QwZsAnCCoJkNHxwgsvgL69e2D5iicCai2OO4WTljwdOVA2bUZBz1WnkCrCh5Fa1o1AmN9LrfVKFES3j5S5sSbi+DRt9BEyBCXcttx+u45KAGbws+PA5iwyMf8hegJ5o5XG+Ks/LQguG14AVKJSt8U6KMLreZpqyHOgKlGSQLWGUE0gVhUskTqJYpNh4qh2Abmv1WtJvZ9Ki3VaKTd9WHlCUetEtYtrdWSPBzlc3CX14p6Q9ME5Z5wCX/yLz8XIiUso+pPRz1czff1fEbud0a/om+XjyaV49913b0FV9bd4LzL8rRX8gD9kAuAQ+lH0cQgTnHOTxowZM5wIgHgF2icJFb/k3LwWEEGpg6SM4Jqrr0r3790NS7GICEAkffqEA1vcmo8AgriGOsLlVc80zqmpxqYa2HYIisi6bmW1HEDsiCMCgoNYYgDCSFKAA6/wRwReeHHmfoL4sk+eM8P1w5CfGzK5BZYaE5h9ww8oFG7LNgcR/7UdGMi6ud9lFC9AHBPCxzBQqUGlGjPiJzXn6/KK1Iq85hlIQOe9SEEGdRnaZcDEkECPiyW+I44Z0R0CoJ4fV/rZ+s/byX540+Jz4cv/43NV1Mc7qK2XFPgYSo4/MZd2XoAss1KrP/n8lyIBIO6/XA1/f7gEwCAmQKrXgfUCpmBcwHiEDokNGCpFbaUO5MQwKUzCRODKKy5Pd27fGqx4amW9O5o06wzDUibjjq/nVwsykR7SDMEILD1XEC20+gA40raOQuQiE/O1FZljpAmYS9acic0BE4MASmEktf8jUQNU7KdtyBIE83TIvO/xyFhPDJHkKD/5kbeNINgKz9uSOCK4Dipxgggfw2AVEX8wgSpuJ86q/Wg3Ia89gt0sE/5rwT4SxWfH6qitvERicGKoreHIsf3C/Qe5m1RSFeTnPP89sOjEE+B//s1fxxjlV8b08nbIr0ifRfasO7Co9R0D2hdiRPxnMOX3DrzXfVLuy/3hEwCDCkKM1vpuVAUmjRo1ahwiZ4j2AEX+oXoFsvkChcegxMGSABke33zN1W7vKzthuUgCkCZ1JBbEMiKgsfUm+jck81h4m+nZ/AzWfJQRXNZxoFGJihEEqcpprkC+N0sF1TiFCkItAYhTh3OBWu1VqhBpwc7lOd6fLf5vhsp8LQCVahr6IPOczVhFHULoGgIhd6WCCI/I3jcQQ/9gDQYR+WuC9EIxjDg6yV/wdXqryycalO03C77lJQinF/B7Cji5Zs3aeJOYXxPkR87P+2gu6YM3XXA2Jvjc'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= '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'
	$AutoIt_Logo &= 'e5FZrMGMvqeQUJF//wHp3devyH+YALx+oYwwGeEUhDMR6Y9Bw9vxSACmoEoQkriNYcRFZcbaW5rNYFi03S7stO1HqjYDJGIktRBBIBWBpBiSFOj5aT5FopBWqlW3c+cubDe1EXbt3hVt3bI12LBpM2xDojBYGYQNm9CFtm8/7OuvsGtPPH4WjaxFiKTISG8P9WnsgOlHTIHheC+slgwzp0+H0aNHpZMnT04nTpjoJk4Yzzo8IkyAHo8AEZw4O4vNiPwMOJ/X6dvDULm+v/5qkZ+OIUJF+n76+OOP70YivBJF/1US2UcEYD1CBd4Ay2ECYD0PxopxcBEiz0lz5syZh9LA9FNOOaVXVALittqApB0hGBoxyB8/FC6VzU0o7EknRVLpuZU4EEEg4kBA27SPOH8aBiEOISJhxVXialCpUAXkAahUa4ig+yGJrU/A8F4kKJ1d0M3nc1RlOmxYd8jWf+dSBDy/otWSGFkUyXFeuTtBljAyvMrFV7PaEQSCNgQg77ZFaYUSehJUU9Yi8XoJcwweF8R/Qtx8VQQ4TADeeG7CYWIXOBOR5xSs+jsXicA8HEeSNICSAYnXKg0M1ThYTBTMY3CgfeV0bBetmEUInzAwUfDbq0lpdZIgaF1B/14/klERmNYJqQkYOZDL6zyNCjTfylo/VFF/qMFWdtzQ3XrtUnqZgFG8wZIlS/qRkK5Bo9/T+C6eFJF/lbTtiv8fe2fi08YVhPFiE2OX2xwBwuEEKG0JUdND/f+lSFFvqjSUpBCSuKbcpy/C4f5mNU+yVqzH9qaX+1b6tIcdCRS+b2a+mfcWcHgB+K8iDWbBF+CrxcXFFUifI3LmMAi7aRuKG9+MQRgtANGlQVRGEL4OZwSWCChM0jR8wYWanA63vQ/fSNHjkT/6sJ1+FUAj0kd7PER7Wcl3gwD8gSi+psW3hqhJb/97rfeLrt73AtAZvsAoeKgG4QrkX8CNFhEYYmbADQ65lYXWH1B9NG5EeEMMzH51uIVoRTWbaPb3rezH2EylDbLbDr9Z6wOzxef26pfx4idPnlTIjF4xdbhJSfNS6/0fwDZ458jvBaCzSoJ+8EANwscLHIjBEsSfXFlZuTMzM+OygfpOQUvdAr4XRfbQ85ZGWA2/oGWS2eS0f8cYBG9JBKIivmnehrd9p70XbN7BUuJDyL9Fi+8F5czPuoHHOjg0Un4vAB3SKpzUbOALHPUVMoAZjKwHnLPaKQgND9nRNkwOhTW3fuv3QGuz7DbajtTqExjC0FZ5YglPrN85vHyXVF96+0XM0g1aqAUW9LzUzTt+AnmjxecFoMOQBANgXrOBR5QAuenp6XmMoRmGiDKsJ5ChHGegRUWcltuHSqio6GqaYzy3SNIKwmLUSlQ1yB07+lv3DcuV+nRf9uvD3CvwWBz+TbKBNSX+mjXS6wWg8w3CCfAJeIw7voxJmIPwd7meXV5evoMoyFBO0F7jecutJmAZiK3U5VaLrRVBsDZDtbMeG5aAtSsAkWIg4kpaHwwh4erLa8ALtEZ3IX4ecX+hdf4voABK1tZdXgA6HwnQB3Lgc7AC+ecwB+fIBnK0CoeZIUjSLXCzA1ZGELVJRaMy4Jazna6D1skUH/HLj/gZwK0+iBBfFhdR29cw94r8f73B3X/F7EJeo/0q+A0ch6O+FwB/pMCYmoTL4CElAENwc/f4A2LSdXx0aWkp6dqGkXsORKMh6RVR5UEY1rZVzRMnPvnDAtd0P9+GXf64PRoZ5gmIzwTfKUbuNgM9e5Lu8/maRvwNsAMqjWp9LwBeFDNgXMuCz8AC48STuVzuHuOus5QEg4wVdzEWK0LgpgmNnrQpBNFiYEf/8HdNMsaP7jaZlaDvNQsI+ygQP9h0hW3BZYy3gnG7RUvvD14LJtN7b8DP4BkogHKzK/i8APgjqWXBNFhSLFAKyADRJBnBCNnBSH1pEHpZSTN/yLcRyfIGjO6BmYFYRG4XlhA0u56/qYhPqh8Qn2hfw90/w6jd'
	$AutoIt_Logo &= 'Qwwk4r/ls01t6b0Ab8GRT/e9AMRZUzAAJsHH4BG4T0YwTmkwQZo5yWq9ETKCJBmBmIX1o8XWvoT16biVCTR6O02YIAapDdLan7WTsZimIzB36EF4A+JT39do5UmNnyfi7+L07+Psv9Vo/xzkwen7HOjxAuCFYBDMgY/AolwjBFMIwTRCMALpR7kO9h7AL5AVe84wjOPMW/dW9I0UHhA32sf6WfQ+UtgQUGfsBasMIbxE/Etae1Lj7yEG4uwXNMpvgpfgFTj4qxbveAHwgpnSjOAuWFCfYJ5INIE3MMwE4TA+wTS7/PTiGQQDRWxT5oTAeQV2686OzmHEIW88k9D2Jxptux2Z4kN0MfZkfb44+heI6e/i3uPyH/F8X4m/pql+AZyA6t8V8b0A+IygH0yBRcUMpLnLHME402ajCME4gjBEidBNZpBAFKREcIuOjA5CrLq+5a4AsMSgnc+a8jDq370I6aV/H5Cecd0r7otE+x2mNI8RgR2EYU/JvqntvDw4Bpf/JPG9AHghGFWfYF4zg2nKgzF8gWEiVx/p6hjEz5IlBHsUYiDKqHG9GDjPIEzWhsYdaC/6R5uP7Rp5ZnQPX7v3LELuYFRX9gnEvb8itT9BQA8g+zn1/jGCcKhr8jeU9AVN88/+TTW+FwAvpmkwBO6B+yoEU2Aoy0G3YASSZ4lqWfyBAQQgiRgk3B6A4hmE3nNoEdGOyvZ3ws/jiInpU7h3JpAdBWYeU3o19gu8xsgrIpTH+CjHPDvgONKUfgdsacT/XYlf6YDpPf9ikA7EFShpdNrWPvRrsMMf/RnRrEjteg5Rjohw57jaJ9SzJXkJBilvN4tTErrDjluX32i/wdBnpoNuRfioSG5F98ghJjeSC+HFxAsm9NbX1z94+vTp9erqapmIv4sgFPhugd95i+MNzzYQyOe6Jv8b8C14piJw9F+L+D4D8FlBD+gDI5oZzIFZNRH7ifh9lAX91LlDEGEAsvRDtuDV54wgJ8VA5LOgXKDXLSWDm0C09hc0onM8k7B+RyJI7KbxAvGCwLJdmHtFmizBvUEErvjslJ//jChfkjSfl4CccZY0vqiimVfBzOv9Oaj6aO8FoBOQAGkwCLIqAGPqHUyAcUg9DNn7MQsHmCXohVQZSJOCYBmuexGANJlDEmHowkwMSgaeBR0GSBXuMsi5nvj63Oy3m7shu+3A3NZhkFgivDj2QTrP/SXfK/HzlCH7O1Cmzi8jBKeIQol/L/15V9fvgn2wp6Q/9RN7XgA6HUnNDDKgFwypgTil5zEwCGEzkDvDkYb0cv4Qgn8I8VIQTwSij4jaA9ESZAUJsoWEZAp8z2UJbjLRiUE9InfM4ezqdYGQPQBRXKK7kL1GhL+GyDWIfSGEJSspIUQXEL9c4UAMyhxVROICsSipYXeghN8B2yoCRSV89f88recFwAtCBvSDAZDVzGBEnw2CIf0sA6l7IXqaLkMG4vWAFGTvgXxJhCEN4VKSAHDfDbrkWu8TXRwR4l+rMxlvNALLucb9tQARuUZcyvI5wlAFl1UO0vwqglDhsqIG3Tk4BqdK/BOwr4R3KX9JCR+qNzy8AHhRvgMyih6QViHIKgbBsIpCn34nJZCMIMWR4EAUEkJ0uSZL6NLjtgBQC9f3kPtGoJlBcH3FIVFdjDhFVYl8qjhR4h/qfQVc6LniDLw/27OXFYSBGAqgOr5F//9DRRRrqxiCka7qQlfnwCVTaFclCaWzr2AAMB99Nmyz7nMAHKPW9S6HyDKeq7QJ7/yRm78fpXs3fOX0Sp6vmUvUn293DABaNvk6s/qorVK/fKcNgDDEuWqfTd3FJq/c657/AQAAAAAAAAAAAOAJv1WubamD8c0AAAAASUVORK5CYII='
	Local $bString = Binary(_Base64Decode($AutoIt_Logo))
	If $bSaveBinary Then
		Local $hFile = FileOpen($sSavePath & "\Icon-Autoit.png", 18)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return  $bString
EndFunc   ;==>_AutoIt_Logo

Func _Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_Base64Decode